<?php
namespace CLOUDMEISTER\CMX\Buero;

defined('ABSPATH') || exit;

/* ------------------------------------------------------------
 * SUPPORT-TAB REGISTRIEREN
 * ------------------------------------------------------------ */
add_action('admin_init', function() {
	add_settings_section(
		'cmx_sec_support',                        // ID
		'Support',                                // Titel
		__NAMESPACE__ . '\\cmx_render_support_tab', // Callback
		'cmx_tab_support'                         // Page-ID
	);
});


/* ------------------------------------------------------------
 * SUPPORT-TAB INHALT
 * ------------------------------------------------------------ */
function cmx_render_support_tab(): void {

	/* SUPPORT SENDEN */
	if (isset($_POST['cmx_support_submit'])) {

		check_admin_referer('cmx_support_nonce');

		$support_mail = 'support@misbuero.ch';
		$current_user = wp_get_current_user();

		$to      = sanitize_email($support_mail);
		$subject = sanitize_text_field($_POST['support_subjet'] ?? '');
		$body    = wp_kses_post($_POST['support_description'] ?? '');

		$headers = [
			'Content-Type: text/html; charset=UTF-8',
			'From: ' . $current_user->user_firstname . ' <' . $current_user->user_email . '>',
			'Reply-To: CLOUD Meister - Support <' . $support_mail . '>',
		];

		$attachments = [];
		if (!empty($_FILES['support_file']['name'])) {
			$upload = wp_handle_upload($_FILES['support_file'], ['test_form' => false]);
			if (empty($upload['error']) && !empty($upload['file'])) {
				$attachments[] = $upload['file'];
			}
		}

		wp_mail($to, $subject, wpautop($body), $headers, $attachments);

		add_settings_error(
			'cmx_support_msg',
			'cmx_support_sent',
			__('Deine Anfrage wurde verschickt und wird schnellstmöglichst von mir bearbeitet.'),
			'updated'
		);
	}

	settings_errors('cmx_support_msg');

	$support_mail = 'support@misbuero.ch';
	$current_user = wp_get_current_user();
	?>

	<h3 class="title">Support-Ticket erstellen</h3>

	<p>
		Hast Du Deine Fragen schon im
		<a href="https://misbuero.ch/handbuch/" target="_blank">Online-Handbuch</a>
		nachgeschaut?
	</p>

	<form action="" method="post" enctype="multipart/form-data">
		<?php wp_nonce_field('cmx_support_nonce'); ?>

		<table class="form-table" role="presentation">
			<tbody>
			<tr>
				<th><label>Absender</label></th>
				<td>
					<input type="text" class="regular-text"
						value="<?php echo esc_attr($current_user->user_email); ?>"
						readonly>
				</td>
			</tr>

			<tr>
				<th><label>Empfänger</label></th>
				<td>
					<input type="text" class="regular-text"
						value="<?php echo esc_attr($support_mail); ?>"
						readonly>
				</td>
			</tr>

			<tr>
				<th><label for="support_subjet">Betreff</label></th>
				<td>
					<input type="text" name="support_subjet"
						class="regular-text"
						style="width:700px;"
						required>
				</td>
			</tr>

			<tr>
				<th><label for="support_description">Beschreibung</label></th>
				<td>
					<textarea name="support_description"
						rows="12" cols="120"
						required></textarea>
				</td>
			</tr>

			<tr>
				<th><label for="support_file">Screenshot</label></th>
				<td>
					<input type="file" name="support_file"
						accept="application/pdf,image/jpeg,image/png">
				</td>
			</tr>

			</tbody>
		</table>

		<p class="submit">
			<button type="submit"
				name="cmx_support_submit"
				class="button button-primary">
				…und ab die Post!
			</button>
		</p>

	</form>

	<?php
}
